/*******************************************************************************************************
 *                                                                                                     *
 *        **********                                                                                   *
 *       ************                                                                                  *
 *      ***        ***                                                                                 *
 *      ***   +++   ***                                                                                *
 *      ***   + +   ***                                                                                *
 *      ***   +                        CHIPCON HARDWARE ABSTRACTION LIBRARY FOR THE CC2420             *
 *      ***   + +   ***                                   Idle looping                                 *
 *      ***   +++   ***                                                                                *
 *      ***        ***                                                                                 *
 *       ************                                                                                  *
 *        **********                                                                                   *
 *                                                                                                     *
 *******************************************************************************************************
 * The Chipcon Hardware Abstraction Library is a collection of functions, macros and constants, which  *
 * can be used to ease access to the hardware on the CC2420 and the target microcontroller.            *
 *                                                                                                     *
 * This file contains a function which initialises the SPI interface on UART1.                     
 *******************************************************************************************************
 * Compiler: MPS430-GCC or IAR C/C++ Compiler for MSP430                               
 * Target platform: MSP430FET CC2420 + any ATMEGA MCU                                                  *
 *******************************************************************************************************
 * Revision history:                                                                                   *
 *  
 *
 *
 *******************************************************************************************************/
#include "include/include.h"

//-------------------------------------------------------------------------------------------------------
//	void halSpiInit(void)
//
//	DESCRIPTION:
//		Initalises the MSP430 Port 3/UART0 for SPI use.
//
//-------------------------------------------------------------------------------------------------------
void halSpiInit(void) {	
	U0CTL  = CHAR + SYNC + MM + SWRST;	// SW  reset, 8-bit transfer, SPI master, Synchronous mode
	U0TCTL = CKPH + SSEL1 + STC;	    	// Data on Rising Edge, SMCLK, 3-wire

	U0BR0  = 0x02;		 	// SPICLK set baud
	U0BR1  = 0;                     // Dont need baud rate control register 2 - clear it
	U0MCTL = 0;		 	// Dont need modulation control

	P3SEL |= BIT1+BIT2+BIT3;		// Select Peripheral functionality (SPI)
//	P3DIR |= BIT1+BIT3;		// | Configure as outputs(SIMO,CLK,CSn)
	P4DIR |= BIT2;			// |
	
	ME1   |= USPIE0;		            // Module enable
	U0CTL &= ~SWRST;	                // Remove RESET
	

} // SpiInit
